function Y = quantif1D(X, f, C)
% quantif1D
%   Quantification des composantes d'un vecteur 1D
%   Y = quantif1D(X, f, C)
%   Y   :   vecteur 1D quantifie
%   X   :   vecteur 1D a quantifier
%   f   :   pour normaliser X
%   C   :   centre (un vecteur 1D)

% Recentrage de X
X_recentre = double( X ) - double( C ) ;

% Normalisation de X_recentre

X_recentre_normalise = double( X_recentre ) * f ;

% Quantification rapide (reseau cubique)

Y = quantifBase( X_recentre_normalise ) ;