function Y = indexTOrepres( index )
% indexTOrepres
%   renvoie le vecteur correspondant a l'index
%   Y = indexTOrepres( index )
%   index   :   index au sein du cube 3x3x3
%   Y       :   vecteur representant (1, 3)


% il y a 27 representants possibles dans l'espace normalise
% ils sont indexes de la facon suivante :
% Y = (i, j, k) ou i = {-1, 0, 1}
%                  j = {-1, 0, 1}
%                  k = {-1, 0, 1}
%               donc :
%                  i+2 = {1, 2, 3}
%                  j+2 = {1, 2, 3}
%                  k+2 = {1, 2, 3}
% => index = (i+2) + ((j+2)-1)*3 + ((k+2)-1)*3*3
%          = (i+2) + (j+1)*3 + (k+1)*9
%          ou index = {1, 2, ... , 27}
%
% donc sequentiellement calculons : 
%   1) (k+1) = floor( index / 9 );
%   2) (j+1) = floor( ( index - (k+1)*9 ) / 3 )
%   3) (i+2) = index - (k+1)*9 - (j+1)*3          


Y(3) = floor( (index - 1) / 9 ) - 1;

Y(2) = floor( ( (index - 1) - (Y(3) + 1) * 9 ) / 3 ) - 1;

Y(1) = index - ((Y(3) + 1) * 9) - ((Y(2) + 1) * 3) - 2;