%==========================================
%==========================================
%==========================================
%==========================================
% 1st ex. with synthetic data 

clear;

%Generate a two-cluster problem
C1 = randn (100, 2) + 1;
C2 = randn (100, 2) - 1;
data = [C1; C2];

nombre_regions=2;

options(14) = 10; % OPTIONS(14) is the maximum number of iterations; default 100.
options(5) = 1;   % OPTIONS(5) is ??
centres = ones(nombre_regions, 2);

centres = ones(nombre_regions,2);

%Perform clustering
%[idx, centers] = kmeans(data, 2);


[centres, options, post, errlog] = kmeans(centres, data, options);


%Plot the result
figure;
%plot (data (idx==1, 1), data (idx==1, 2), 'ro');
plot (data(1:100, 1), data(1:100, 2), 'ro');
hold on;
plot (data(101:200, 1), data(101:200, 2), 'go');
hold on;

%plot (data (idx==2, 1), data (idx==2, 2), 'bs');
plot (centres (:, 1), centres (:, 2), 'k*');
hold off;


input ("Press <enter> to continue: ", "s");


%==========================================
%==========================================
%==========================================
%==========================================
% 2nd ex. with an image 

clear;
close all;


% Classification non supervisee
% basee k-means

nom_image='tampere2.jpg';

nombre_regions=2;

%%%

image_apprentissage1 = imread(nom_image);
image_apprentissage1 = image_apprentissage1(40:50, 50:60, :);

figure()
imshow( image_apprentissage1 )

im_app1_hsv = rgb2hsv(image_apprentissage1);

vecteur_app_1 = range_en_vecteur(im_app1_hsv);
vecteur_attributs = [vecteur_app_1;];

%% on ne s'interesse qu'aux composantes Teinte et Saturation
%% (on n'utilise pas la composante "Value" (quantit de lumire))
v = vecteur_attributs(:,1:2);

options(14) = 10; % OPTIONS(14) is the maximum number of iterations; default 100.
options(5) = 1;   % OPTIONS(5) is ??
centres = ones(nombre_regions, 2);

input ("Press <enter> to continue: ", "s");

%%%%%%%%%%%%%%%% FAIRE APPEL A L'ALGO K-MEANS

[centres, options, post, errlog] = kmeans(centres, v, options);

image_output = ones( size(image_apprentissage1, 1), size(image_apprentissage1, 2) );
nb_colonnes = size(image_apprentissage1, 1);
i=0;
classe = ones(length(v), 1); 

for y=1:size(image_apprentissage1,2)
    for x=1:size(image_apprentissage1,1)
        i=i+1;
        classe(i)=find(post(i,:));
        image_output(1+x,1+y)=classe(i)*32;
    end
end

col=ones(size(centres,1),3);
col(1,:)=[255,0,0];
col(2,:)=[0,255,0];
col(3,:)=[0,0,255];
col(4,:)=[255,255,0];
col(5,:)=[255,0,255];
col(6,:)=[0,255,255];

hold on;
subplot(1,2,1);
hold on;

for i=1:length(v)
    switch classe(i)
        case 1
        plot(v(i,1),v(i,2),'or');
        case 2
        plot(v(i,1),v(i,2),'xb');
        case 3
        plot(v(i,1),v(i,2),'*k');
        case 4
        plot(v(i,1),v(i,2),'.g');
        case 5
        plot(v(i,1),v(i,2),'>c');
    end
end

hold off;

%%%%%%%%%%%%%%%%%%%% AFFICHER L'IMAGE ET LES CONTOURS DE REGIONS

% les regions dans l'image segmentes correspondant 
%   aux classes obtenues via le k-means
%   => si k regions dans le k-means -> plus de k rgions dans l'image 

im = image_output;
im_grad = image_apprentissage1;

for i=2:size(im,1)-1
    for j=2:size(im,2)-1
        
        g = abs( im(i,j) - im(i+1,j) ) 
            + abs( im(i,j) - im(i,j+1) )
            + abs( im(i+1,j) - im(i,j+1) ) 
            + abs( im(i,j) - im(i+1,j+1) );
          
        g = g + abs( im(i,j) - im(i-1,j) ) 
            + abs( im(i,j) - im(i,j-1) ) 
            + abs( im(i-1,j) - im(i,j-1) ) 
            + abs( im(i,j) - im(i-1,j-1) );
            
        if (g>0)
           im_grad(i,j,:) = [255 255 255];
        else 
           im_grad(i,j,:) = image_apprentissage1(i,j,:);
        end
       
    end
end

subplot(1,2,2);
imagesc(im_grad);



